DROP PROCEDURE [hips].[HospitalHealthProviderIndividualInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 23 October 2012
-- Description:   Inserts a new record into the Hospital Health Care Provider Table
-- =============================================

CREATE PROCEDURE [hips].[HospitalHealthProviderIndividualInsert] 
(
	@HospitalId INT,
	@HealthProviderIndividualId INT,
	@CisProviderIdentifier VARCHAR(30) = NULL,
	@PasProviderIdentifier VARCHAR(30),
	@UserModified VARCHAR(256)
) 
AS
BEGIN
	SET NOCOUNT ON

   DECLARE @intErrorCode INT
          
    SET @intErrorCode = 0
	INSERT INTO [hips].[HospitalHealthProviderIndividual]
	        ( HospitalId ,
	          HealthProviderIndividualId ,
	          CisProviderIdentifier ,
	          PasProviderIdentifier ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  ( @HospitalId ,
	          @HealthProviderIndividualId , 
	          @CisProviderIdentifier , 
	          @PasProviderIdentifier ,
	          GETDATE() , 
	          @UserModified , 
	          GETDATE() , 
	          @UserModified  
	        )
	        
	 SELECT @intErrorCode = @@ERROR 
    IF @intErrorCode = 0
    BEGIN
	SELECT
			  HospitalId ,
	          HealthProviderIndividualId ,
	          CisProviderIdentifier ,
	          PasProviderIdentifier ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	FROM [hips].[HospitalHealthProviderIndividual]
	WHERE @HospitalId = HospitalId
	AND   @HealthProviderIndividualId = HealthProviderIndividualId

    END

    RETURN(@intErrorCode)

	

END
GO

